# AI dla pojazdów autonomicznych – budowa samojezdnego pojazdu

# Tworzenie środowiska

# Import bibliotek
import numpy as np
from random import random, randint
import matplotlib.pyplot as plt
import time

# Import pakietów Kivy
from kivy.app import App
from kivy.uix.widget import Widget
from kivy.uix.button import Button
from kivy.graphics import Color, Ellipse, Line
from kivy.config import Config
from kivy.properties import NumericProperty, ReferenceListProperty, ObjectProperty
from kivy.vector import Vector
from kivy.clock import Clock

# Importowanie obiektu Dqn z AI z ia.py
from ai import Dqn

# Dodaj tą linię jeśli nie chcesz aby kliknięcie prawego przycisku myszy powodowało umieszczenie czerwonego punktu
Config.set('input', 'mouse', 'mouse,multitouch_on_demand')

# Wprowadzenie last_x i last_y, używane do przechowywania ostatniego punktu w pamięci kiedy rysujemy mapę
last_x = 0
last_y = 0
n_points = 0 # całkowita liczba punktów w czasie ostatniego rysowania
length = 0 # długość ostatniego rysowania

# Tworzenie mózgu AI, listy działań i zmiennej dla nagrody
brain = Dqn(4,3,0.9) # 4 wejścia, 3 działania, gamma = 0.9
action2rotation = [0,20,-20] # akcja = 0 => bez obrotu, akcja = 1 => obrót o 20 stopni, akcja = 2 => obrót o -20 stopni
reward = 0 # inicjalizacja nagrody po osiągnięciu nowego stanu

# Inicjalizacja mapy
first_update = True # inicjalizuje mapę tylko raz
def init():
    global sand # sand to tablica zawierająca tyle komórek, ile pikseli ma nasz interfejs graficzny. Każda komórka ma wartość jeden, jeśli jest piasek, a 0 w przeciwnym razie.
    global goal_x # współrzędna x celu (gdzie samochód ma jechać, albo do cetrum miasta albo na lotnisko)
    global goal_y # współrzędna y celu (gdzie samochód ma jechać, albo do cetrum miasta albo na lotnisko)
    global first_update # inicjator mapy
    sand = np.zeros((longueur,largeur)) # inicjalizacja tablicy sand samymi zerami
    goal_x = 20 # cel do osiągnięcia znajduje się w lewym górnym rogu mapy (współrzędna x wynosi 20, a nie 0, ponieważ samochód otrzymuje złą nagrodę, jeśli dotknie ściany)
    goal_y = largeur - 20 # cel do osiągnięcia znajduje się w lewym górnym rogu mapy (współrzędna y)
    first_update = False # inicjalizuje mapę tylko raz

# Inicjalizacja zmiennej reprezentującej odległość pomiędzy samochodem a celem
last_distance = 0

# Tworzenie klasy samochodu (aby zrozumieć "NumericProperty" i "ReferenceListProperty", zobacz tutorial kivy: https://kivy.org/docs/tutorials/pong.html)

class Car(Widget):

    angle = NumericProperty(0) # inicjalizacja kąta samochodu (kąt pomiędzy osią x mapy a osią samochodu)
    rotation = NumericProperty(0) # inicjalizacja ostatniego obrotu auta (po rozegraniu akcji auto wykonuje obrót o 0, 20 lub -20 stopni)
    velocity_x = NumericProperty(0) # inicjalizacja współrzędnej x wektora prędkości
    velocity_y = NumericProperty(0) # inicjalizacja współrzędnej y wektora prędkości
    velocity = ReferenceListProperty(velocity_x, velocity_y) # wektor prędkości
    sensor1_x = NumericProperty(0) # inicjalizacja współrzędnej x pierwszego czujnika (tego, który patrzy do przodu)
    sensor1_y = NumericProperty(0) # inicjalizacja współrzędnej y pierwszego czujnika (tego, który patrzy do przodu)
    sensor1 = ReferenceListProperty(sensor1_x, sensor1_y) # pierwszy wektor czujnika
    sensor2_x = NumericProperty(0) # inicjalizacja współrzędnej x drugiego czujnika (tego, który patrzy 30 stopni w lewo)
    sensor2_y = NumericProperty(0) # inicjalizacja współrzędnej y drugiego czujnika (tego, który patrzy 30 stopni w lewo)
    sensor2 = ReferenceListProperty(sensor2_x, sensor2_y) # drugi wektor czujnika
    sensor3_x = NumericProperty(0) # inicjalizacja współrzędnej x trzeciego czujnika (tego, który patrzy 30 stopni w prawo)
    sensor3_y = NumericProperty(0) # inicjalizacja współrzędnej y trzeciego czujnika (tego, który patrzy 30 stopni w prawo)
    sensor3 = ReferenceListProperty(sensor3_x, sensor3_y) # trzeci wektor czujnika
    signal1 = NumericProperty(0) # inicjalizacja sygnału odebranego przez czujnik 1
    signal2 = NumericProperty(0) # inicjalizacja sygnału odebranego przez czujnik 2
    signal3 = NumericProperty(0) # inicjalizacja sygnału odebranego przez czujnik 3

    def move(self, rotation):
        self.pos = Vector(*self.velocity) + self.pos # aktualizacja pozycji samochodu zgodnie z jego ostatnią pozycją i prędkością
        self.rotation = rotation # uzyskanie obrotu samochodu
        self.angle = self.angle + self.rotation # aktualizacja kąta
        self.sensor1 = Vector(30, 0).rotate(self.angle) + self.pos # aktualizacja położenia czujnika 1
        self.sensor2 = Vector(30, 0).rotate((self.angle+30)%360) + self.pos # aktualizacja położenia czujnika 2
        self.sensor3 = Vector(30, 0).rotate((self.angle-30)%360) + self.pos # aktualizacja położenia czujnika 3
        self.signal1 = int(np.sum(sand[int(self.sensor1_x)-10:int(self.sensor1_x)+10, int(self.sensor1_y)-10:int(self.sensor1_y)+10]))/400. # uzyskanie sygnału odebranego przez czujnik 1 (gęstość piasku wokół czujnika 1)
        self.signal2 = int(np.sum(sand[int(self.sensor2_x)-10:int(self.sensor2_x)+10, int(self.sensor2_y)-10:int(self.sensor2_y)+10]))/400. # uzyskanie sygnału odebranego przez czujnik 1 (gęstość piasku wokół czujnika 2)
        self.signal3 = int(np.sum(sand[int(self.sensor3_x)-10:int(self.sensor3_x)+10, int(self.sensor3_y)-10:int(self.sensor3_y)+10]))/400. # uzyskanie sygnału odebranego przez czujnik 1 (gęstość piasku wokół czujnika 3)
        if self.sensor1_x > longueur-10 or self.sensor1_x<10 or self.sensor1_y>largeur-10 or self.sensor1_y<10: # jeśli czujnik 1 jest poza mapą (samochód jest skierowany w stronę krawędzi mapy)
            self.signal1 = 1. # czujnik 1 wykrywa pełny piasek
        if self.sensor2_x > longueur-10 or self.sensor2_x<10 or self.sensor2_y>largeur-10 or self.sensor2_y<10: # jeśli czujnik 2 jest poza mapą (samochód jest skierowany w stronę krawędzi mapy)
            self.signal2 = 1. # czujnik 2 wykrywa pełny piasek
        if self.sensor3_x > longueur-10 or self.sensor3_x<10 or self.sensor3_y>largeur-10 or self.sensor3_y<10: # jeśli czujnik 3 jest poza mapą (samochód jest skierowany w stronę krawędzi mapy)
            self.signal3 = 1. # czujnik 3 wykrywa pełny piasek

class Ball1(Widget): # czujnik 1 (zobacz tutorial: kivy https://kivy.org/docs/tutorials/pong.html)
    pass
class Ball2(Widget): # czujnik 2 (zobacz tutorial: kivy https://kivy.org/docs/tutorials/pong.html)
    pass
class Ball3(Widget): # czujnik 3 (zobacz tutorial: kivy https://kivy.org/docs/tutorials/pong.html)
    pass

# Tworzenie klasy gry (aby zrozumieć "ObjectProperty" , zobacz tutorial kivy: https://kivy.org/docs/tutorials/pong.html)

class Game(Widget):

    car = ObjectProperty(None) # pobieranie obiektu samochodu z naszego pliku kivy
    ball1 = ObjectProperty(None) # pobieranie obiektu czujnika 1 z naszego pliku kivy
    ball2 = ObjectProperty(None) # pobieranie obiektu czujnika 2 z naszego pliku kivy
    ball3 = ObjectProperty(None) # pobieranie obiektu czujnika 3 z naszego pliku kivy

    def serve_car(self): # uruchomienie samochodu w momencie uruchomienia aplikacji
        self.car.center = self.center # samochód zostanie uruchomiony na środku mapy
        self.car.velocity = Vector(6, 0) # samochód zacznie jechać poziomo w prawo z prędkością 6

    def update(self, dt): # duża funkcja aktualizacji, która aktualizuje wszystko, co wymaga aktualizacji w każdym dyskretnym czasie t po osiągnięciu nowego stanu (otrzymywanie nowych sygnałów z czujników)

        global brain # określenie zmiennych globalnych (mózg samochodu, czyli nasza sztuczna inteligencja)
        global reward # określenie zmiennych globalnych (ostatnia otrzymana nagroda)
        global last_distance # określenie zmiennych globalnych (ostatnia odległość od samochodu do celu)
        global goal_x # określenie zmiennych globalnych (współrzędna x celu)
        global goal_y # określenie zmiennych globalnych (współrzędna y celu)
        global longueur # określenie zmiennych globalnych (szerokość mapy)
        global largeur # określenie zmiennych globalnych (wysokość mapy)

        longueur = self.width # width of the map (horizontal edge)
        largeur = self.height # height of the map (vertical edge)
        if first_update: # trick to initialize the map only once
            init()

        xx = goal_x - self.car.x # różnica współrzędnych x między celem a samochodem
        yy = goal_y - self.car.y # różnica współrzędnych y między celem a samochodem
        orientation = Vector(*self.car.velocity).angle((xx,yy))/180. # kierunek samochodu względem celu (jeśli samochód zmierza idealnie do celu, wówczas orientacja = 0)
        state = [orientation, self.car.signal1, self.car.signal2, self.car.signal3] # nasz wektor stanu wejściowego, składający się z orientacji oraz trzech sygnałów odebranych przez trzy czujniki
        action = brain.update(state, reward) # aktualizowanie wag sieci neuronowej w naszym ai i odtwarzanie nowej akcji
        rotation = action2rotation[action] # zamiana odgrywanej akcji (0, 1 lub 2) na kąt obrotu (0°, 20° lub -20°)
        self.car.move(rotation) # poruszanie samochodem zgodnie z ostatnim kątem obrotu
        distance = np.sqrt((self.car.x - goal_x)**2 + (self.car.y - goal_y)**2) # uzyskanie nowej odległości między samochodem a celem zaraz po tym, jak samochód ruszył
        self.ball1.pos = self.car.sensor1 # aktualizacja położenia pierwszego czujnika (ball1) zaraz po ruszeniu auta
        self.ball2.pos = self.car.sensor2 # aktualizacja położenia drugiego czujnika (ball2) zaraz po ruszeniu auta
        self.ball3.pos = self.car.sensor3 # aktualizacja położenia trzeciego czujnika (ball3) zaraz po ruszeniu auta

        if sand[int(self.car.x),int(self.car.y)] > 0: # jeśli samochód jest na piasku
            self.car.velocity = Vector(1, 0).rotate(self.car.angle) # jest spowolniony (speed = 1)
            reward = -1 # i reward = -1
        else: # w przeciwnym wypadku
            self.car.velocity = Vector(6, 0).rotate(self.car.angle) # porusza się z normalną prędkością (speed = 6)
            reward = -0.2 # i otrzymuje nagrodę -0.2
            if distance < last_distance: # jednak jeśli zbliża się do celu
                reward = 0.1 # nadal otrzymuje lekko pozytywną nagrodę w wysokości 0.1

        if self.car.x < 10: # jeśli samochód znajduje się po lewej stronie ramki
            self.car.x = 10 # odsuwa się 10 pikseli od krawędzi
            reward = -1 # i otrzymuje nagrodę -1
        if self.car.x > self.width-10: # jeśli samochód znajduje się po prawej stronie ramki
            self.car.x = self.width-10 # odsuwa się 10 pikseli od krawędzi
            reward = -1 # i otrzymuje nagrodę -1
        if self.car.y < 10: # jeśli samochód znajduje się na dolnej krawędzi ramki
            self.car.y = 10 # odsuwa się 10 pikseli od krawędzi
            reward = -1 # i otrzymuje nagrodę -1
        if self.car.y > self.height-10: # jeśli samochód znajduje się na górnej krawędzi ramki
            self.car.y = self.height-10 # odsuwa się 10 pikseli od krawędzi
            reward = -1 # i otrzymuje nagrodę -1

        if distance < 100: # kiedy samochód osiągnie swój cel
            goal_x = self.width - goal_x # cel staje się prawym dolnym rogiem mapy (centrum miasta) i odwrotnie (aktualizacja współrzędnej x celu)
            goal_y = self.height - goal_y # cel staje się prawym dolnym rogiem mapy (centrum miasta) i odwrotnie (aktualizacja współrzędnej y celu)

        # Aktualizacja ostatniej odległości od samochodu do celu
        last_distance = distance

# Malowanie interfejsu graficznego (zobacz samouczki Kivy: https://kivy.org/docs/tutorials/firstwidget.html)

class MyPaintWidget(Widget):

    def on_touch_down(self, touch): # wsypywanie piasku, gdy klikamy lewy przycisk myszy
        global length,n_points,last_x,last_y
        with self.canvas:
            Color(0.8,0.7,0)
            d=10.
            touch.ud['line'] = Line(points = (touch.x, touch.y), width = 10)
            last_x = int(touch.x)
            last_y = int(touch.y)
            n_points = 0
            length = 0
            sand[int(touch.x),int(touch.y)] = 1

    def on_touch_move(self, touch): # wysypywanie piasku, gdy poruszamy myszą trzymając wciśnięty lewy przycisk
        global length,n_points,last_x,last_y
        if touch.button=='left':
            touch.ud['line'].points += [touch.x, touch.y]
            x = int(touch.x)
            y = int(touch.y)
            length += np.sqrt(max((x - last_x)**2 + (y - last_y)**2, 2))
            n_points += 1.
            density = n_points/(length)
            touch.ud['line'].width = int(20*density + 1)
            sand[int(touch.x) - 10 : int(touch.x) + 10, int(touch.y) - 10 : int(touch.y) + 10] = 1
            last_x = x
            last_y = y

# Interfejs API i przełączniki (zobacz samouczki kivy: https://kivy.org/docs/tutorials/pong.html)

class CarApp(App):

    def build(self): # building the app
        parent = Game()
        parent.serve_car()
        Clock.schedule_interval(parent.update, 1.0 / 60.0)
        self.painter = MyPaintWidget()
        clearbtn = Button(text='clear')
        savebtn = Button(text='save',pos=(parent.width,0))
        loadbtn = Button(text='load',pos=(2*parent.width,0))
        clearbtn.bind(on_release=self.clear_canvas)
        savebtn.bind(on_release=self.save)
        loadbtn.bind(on_release=self.load)
        parent.add_widget(self.painter)
        parent.add_widget(clearbtn)
        parent.add_widget(savebtn)
        parent.add_widget(loadbtn)
        return parent

    def clear_canvas(self, obj): # przycisk clear 
        global sand
        self.painter.canvas.clear()
        sand = np.zeros((longueur,largeur))

    def save(self, obj): # przycisk save 
        print("saving brain...")
        brain.save()

    def load(self, obj): # przycisk load 
        print("loading last saved brain...")
        brain.load()

# Uruchomienie aplikacji
if __name__ == '__main__':
    CarApp().run()
